using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.GUI.controls
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///User control to allow users to select an invoice from an available list
		///</summary>

		#endregion


	public class InvoiceSelectTool : GUI.controls.BaseControl
	{
	
		#region Events Declarations

		private System.EventHandler onInvoiceSelected;
		private System.EventHandler onInvoiceDeselected;
		private System.EventHandler onDoubleClicked;
		
		#endregion

		#region Variables

		private bool bIncomingShipment;
		private OutgoingShipmentCollection _invoice;
		private DataTable _lvListSource;
		private System.Collections.ArrayList _lvListSourceAL;
		private bool _usingDataTable;

		#endregion

		#region Controls

		private System.Windows.Forms.GroupBox grpNewWorklist;
		private System.Windows.Forms.ListView lvInvoices;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		
		#endregion


		#region Constructors
		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// InvoiceSelectTool class constructor
		/// </summary>
		public InvoiceSelectTool()
		{
			InitializeComponent();
			//
			lvInvoices.Items.Clear();
			
			//
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion


		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.grpNewWorklist = new System.Windows.Forms.GroupBox();
			this.lvInvoices = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.grpNewWorklist.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpNewWorklist
			// 
			this.grpNewWorklist.AccessibleDescription = "Select Invoice";
			this.grpNewWorklist.AccessibleName = "Select Invoice";
			this.grpNewWorklist.Controls.Add(this.lvInvoices);
			this.grpNewWorklist.Dock = System.Windows.Forms.DockStyle.Fill;
			this.grpNewWorklist.Location = new System.Drawing.Point(0, 0);
			this.grpNewWorklist.Name = "grpNewWorklist";
			this.grpNewWorklist.Size = new System.Drawing.Size(352, 132);
			this.grpNewWorklist.TabIndex = 6;
			this.grpNewWorklist.TabStop = false;
			this.grpNewWorklist.Text = "Select Invoice";
			// 
			// lvInvoices
			// 
			this.lvInvoices.AccessibleDescription = "Select Invoice";
			this.lvInvoices.AccessibleName = "Select Invoice";
			this.lvInvoices.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvInvoices.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader1,
																						 this.columnHeader3,
																						 this.columnHeader2});
			this.lvInvoices.FullRowSelect = true;
			this.lvInvoices.Location = new System.Drawing.Point(8, 16);
			this.lvInvoices.MultiSelect = false;
			this.lvInvoices.Name = "lvInvoices";
			this.lvInvoices.Size = new System.Drawing.Size(334, 108);
			this.lvInvoices.TabIndex = 6;
			this.lvInvoices.View = System.Windows.Forms.View.Details;
			this.lvInvoices.DoubleClick += new System.EventHandler(this.lvInvoices_DoubleClick);
			this.lvInvoices.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvInvoices_ColumnClick);
			this.lvInvoices.SelectedIndexChanged += new System.EventHandler(this.lvInvoices_SelectedIndexChanged);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Invoice";
			this.columnHeader1.Width = 80;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Shipper";
			this.columnHeader3.Width = 100;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Date/Time Received";
			this.columnHeader2.Width = 130;
			// 
			// InvoiceSelectTool
			// 
			this.Controls.Add(this.grpNewWorklist);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "InvoiceSelectTool";
			this.Size = new System.Drawing.Size(352, 132);
			this.Paint += new System.Windows.Forms.PaintEventHandler(this.InvoiceSelectTool_Paint);
			this.grpNewWorklist.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Gets or sets text to display on control
		/// </summary>
		[
		Category("Appearance"),
		Description("Text display in control"),
		Bindable(false),
		Browsable(true),
		]
		new public string Text
		{
			get
			{
				return this.grpNewWorklist.Text;
			}
			set
			{
				this.grpNewWorklist.Text = value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets docking style property
		/// </summary>
		[
		Category("Layout"),
		Description("Docking style"),
		Bindable(false),
		Browsable(true),
		]
		public override DockStyle Dock 
		{
			get 
			{ 
				return base.Dock; 
			}
			set 
			{ 
				base.Dock = value; 
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Gets or sets anchor style property
		/// </summary>
		[
		Category("Layout"),
		Description("Anchor style"),
		Bindable(false),
		Browsable(true),
		]
		public override AnchorStyles Anchor
		{
			get 
			{ 
				return base.Anchor; 
			}
			set 
			{ 
				base.Anchor = value; 
			}
		}

		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Gets or sets incoming shipment indicator
		/// </summary>
		[
		Category("Design"),
		Description("Direction of Shipment. Incoming true, Outgoing false"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool IncomingShipment
		{
			get 
			{ 
				return bIncomingShipment; 
			}
			set 
			{
				bIncomingShipment = value;
				if (bIncomingShipment)
				{
					lvInvoices.Columns[1].Text = "Shipper";
					lvInvoices.Columns[2].Text = "Date Received";
				}
				else
				{
					lvInvoices.Columns[1].Text = "Ship To";
					lvInvoices.Columns[2].Text = "Date Processed";
				}
			}
		}

		/// <summary>
		/// Milk, milk, lemonade, turn the corner, fudge is made.
		/// </summary>
		public bool UsingDataTable
		{
			get 
			{ 
				return this._usingDataTable; 
			}
			set 
			{
				this._usingDataTable = value;
			}
		}

		

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Gets invoice selected in control
		/// </summary>
		public OutgoingShipmentCollection SelectedInvoice
		{
			get 
			{
				return _invoice; 
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Gets or sets table of invoices to populate selectable invoices
		/// </summary>
		public DataTable InvoiceListSource
		{
			get
			{
				return _lvListSource;
			}
			set
			{
				this.UsingDataTable = true;
				_lvListSource = value;
				if (_lvListSource != null) 
				{
					try
					{
						lvInvoices.Items.Clear();
						//
						foreach(DataRow invoiceItem in _lvListSource.Rows)
						{
							ListViewItem lviInvoice = new ListViewItem();
							//
							lviInvoice.Text = invoiceItem[TABLE.Shipment.InvoiceNumber].ToString();
							lviInvoice.SubItems.Add((string)invoiceItem[TABLE.Facility.FacilityName]);
							lviInvoice.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(invoiceItem[TABLE.Shipment.ShipmentDate]));
							lviInvoice.Tag = invoiceItem;
							lvInvoices.Items.Add(lviInvoice);
						}
						//
						controls.VbecsFunction.SetColumnWidths(lvInvoices);
					}
					catch(Exception ex)
					{
						ExceptionManagement.ExceptionManager.Publish(ex);
					}
				}

			}
		}

		/// <summary>
		/// Get/Set InvoiceListSourceAL
		/// </summary>
		public System.Collections.ArrayList InvoiceListSourceAL
		{
			get
			{
				return _lvListSourceAL;
			}
			set
			{
				this.UsingDataTable = false;
				_lvListSourceAL = value;
				if (_lvListSourceAL != null) 
				{
					try
					{
						lvInvoices.Items.Clear();
						//
						foreach(Object obj in this._lvListSourceAL)
						{
							BOL.IncomingShipment incomingShipment = (BOL.IncomingShipment) obj;
							ListViewItem lviInvoice = new ListViewItem();
							//
							lviInvoice.Text = incomingShipment.InvoiceNumber;
							lviInvoice.SubItems.Add(incomingShipment.LocalSupplier.FacilityName);
							lviInvoice.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString (incomingShipment.ShipmentDate));

						
							lviInvoice.Tag = incomingShipment;
							lvInvoices.Items.Add(lviInvoice);
						}
						//
						controls.VbecsFunction.SetColumnWidths(lvInvoices);
					}
					catch(Exception ex)
					{
						ExceptionManagement.ExceptionManager.Publish(ex);
					}
				}
				else
				{
					lvInvoices.Items.Clear();
				}

			}
		}


		#endregion


		#region Events

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Invoice selected event
		/// </summary>
		public event EventHandler InvoiceSelected
		{
			add 
			{ 
				onInvoiceSelected += value; 
			}
			remove 
			{ 
				onInvoiceSelected -= value; 
			}
		}
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2005</CreationDate>
		/// <summary>
		/// double click event
		/// </summary>
		public event EventHandler DoubleClicked
		{
			add
			{
				onDoubleClicked += value;
			}
			remove
			{
				onDoubleClicked -= value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Invoice deselected event
		/// </summary>
		public event EventHandler InvoiceDeselected
		{
			add 
			{ 
				onInvoiceDeselected += value; 
			}
			remove 
			{ 
				onInvoiceDeselected -= value; 
			}
		}

		/// <summary>
		/// Invoice selected event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnInvoiceSelected(object sender, System.EventArgs e)
		{
			if (onInvoiceSelected!=null) 
			{
				onInvoiceSelected(sender,e); 
			}
		}

		/// <summary>
		/// Invoice deselected event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		protected virtual void OnInvoiceDeselected(object sender, System.EventArgs e)
		{
			if (onInvoiceDeselected!=null) 
			{
				onInvoiceDeselected(sender,e);
			}
		}

		/// <summary>
		/// Double Clicked Event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		protected virtual void OnDoubleClicked(object sender, System.EventArgs e)
		{
			if (onDoubleClicked!=null) 
			{
				onDoubleClicked(sender,e); 
			}
		}
		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Selected index changed event handler. Updates shipment and raises selected or deselected event as appropriate
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void lvInvoices_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.OnUserActivity();
			if (lvInvoices.SelectedItems.Count > 0)
			{
				if(this.UsingDataTable)
				{
					DataRow dr = (DataRow)lvInvoices.SelectedItems[0].Tag;

					_invoice = new OutgoingShipmentCollection((System.Guid)dr[TABLE.Shipment.ShipmentGuid]);
				}
				else
				{
					BOL.IncomingShipment incomingShipment = (BOL.IncomingShipment) lvInvoices.SelectedItems[0].Tag;
					_invoice = new OutgoingShipmentCollection(incomingShipment.ShipmentGuid);
				}

				OnInvoiceSelected(sender,e);
			}
			else
			{
				OnInvoiceDeselected(sender,e);
			}
		}
		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Column click event. Sorts display based on column header clicked
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Column click event args</param>
		private void lvInvoices_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			//lvInvoices.ListViewItemSorter = new SortBySubItem(e.Column);
			//
			if (e.Column == 2)
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvInvoices.CheckBoxes, ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvInvoices.CheckBoxes, ColumnClickSorter.ColumnSortType.String);
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/15/2003</CreationDate>
		/// <summary>
		/// Paint event handler. Defaults focus to list view.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Paint event args</param>
		private void InvoiceSelectTool_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			lvInvoices.Focus();
		}

		private void lvInvoices_DoubleClick(object sender, System.EventArgs e)
		{
			OnDoubleClicked(sender,e);
		}

		#endregion
	

		#region Methods

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// Select invoice in control matching supplied shipment unique identifier
		/// </summary>
		/// <param name="shipmentGuid">Shipment unique identifier</param>
		public void SelectInvoice(System.Guid shipmentGuid)
		{
			if(this.UsingDataTable)
			{
				foreach(ListViewItem lvi in lvInvoices.Items)
				{
					DataRow dr = (DataRow)lvi.Tag;
					if ((System.Guid)dr[TABLE.Shipment.ShipmentGuid] == shipmentGuid)
					{
						lvi.Selected = true;
						lvi.EnsureVisible();
						lvInvoices_SelectedIndexChanged(null,EventArgs.Empty);
						break;
					}
				}
			}
			else
			{
				foreach(ListViewItem lvi in lvInvoices.Items)
				{
					BOL.IncomingShipment incomingShipment = (BOL.IncomingShipment)lvi.Tag;
					if (incomingShipment.ShipmentGuid == shipmentGuid)
					{
						lvi.Selected = true;
						lvi.EnsureVisible();
						lvInvoices_SelectedIndexChanged(null,EventArgs.Empty);
						break;
					}
				}

			}
		}
        
		#endregion

	}
}

